/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsbuilder.modules.mover.blocks.MoverTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketSyncVehicleInformationToClient {
    private final BlockPos pos;
    private final List<String> platforms;
    private final String currentPlatform;
    private final boolean valid;
    private final boolean enoughPower;

    public PacketSyncVehicleInformationToClient(BlockPos pos, List<String> platforms, String currentPlatform, boolean valid, boolean enoughPower) {
        this.pos = pos;
        this.platforms = platforms;
        this.currentPlatform = currentPlatform;
        this.valid = valid;
        this.enoughPower = enoughPower;
    }

    public PacketSyncVehicleInformationToClient(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        int size = buf.readInt();
        this.platforms = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            this.platforms.add(buf.m_130136_(Short.MAX_VALUE));
        }
        this.currentPlatform = buf.m_130136_(Short.MAX_VALUE);
        this.valid = buf.readBoolean();
        this.enoughPower = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.platforms.size());
        for (String s : this.platforms) {
            buf.m_130070_(s);
        }
        buf.m_130070_(this.currentPlatform);
        buf.writeBoolean(this.valid);
        buf.writeBoolean(this.enoughPower);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            BlockEntity patt1893$temp = SafeClientTools.getClientWorld().m_7702_(this.pos);
            if (patt1893$temp instanceof MoverTileEntity) {
                MoverTileEntity mover = (MoverTileEntity)patt1893$temp;
                mover.setClientRenderInfo(this.platforms, this.currentPlatform, this.valid, this.enoughPower);
            }
        });
        ctx.setPacketHandled(true);
    }
}

